import { NextResponse } from 'next/server';
import { postgresClient } from '../../../../lib/postgresql-client';

export async function GET() {
  try {
    // Получить все устройства с расширенными user-данными и техническими данными
    const query = `
      SELECT 
        u.user_id,
        u.device_id,
        u.uid,
        u.fcm_token,
        d.device_name,
        d.device_type
      FROM devices d
      LEFT JOIN users u ON d.device_name = u.device_id
      ORDER BY d.device_name
    `;
    const result = await postgresClient.query(query);
    return NextResponse.json({ devices: result.rows });
  } catch (error) {
    console.error('Failed to fetch all user devices for admin:', error);
    return NextResponse.json({ 
      error: 'Failed to fetch all user devices for admin', 
      details: error instanceof Error ? error.message : 'Unknown error' 
    }, { status: 500 });
  }
} 