"use client";

import React from 'react';
import { BarChart3, Settings, Bell, CheckSquare, ShoppingCart, CreditCard } from 'lucide-react';
import { useTranslation } from 'react-i18next';

interface MobileNavigationProps {
  activeTab: string;
  setActiveTab: (tab: string) => void;
  tabs: Array<{ id: string; label: string }>;
}

export function MobileNavigation({ activeTab, setActiveTab, tabs }: MobileNavigationProps) {
  const { t } = useTranslation();

  const mobileTabs = tabs.filter(tab => ['dashboard', 'admin', 'notifications', 'approvals', 'orders'].includes(tab.id));

  const getTabIcon = (tabId: string) => {
    switch (tabId) {
      case 'dashboard':
        return <BarChart3 className="h-5 w-5" />;
      case 'admin':
        return <Settings className="h-5 w-5" />;
      case 'notifications':
        return <Bell className="h-5 w-5" />;
      case 'approvals':
        return <CheckSquare className="h-5 w-5" />;
      case 'orders':
        return <ShoppingCart className="h-5 w-5" />;
      default:
        return <BarChart3 className="h-5 w-5" />;
    }
  };

  const getTabLabel = (tabId: string) => {
    switch (tabId) {
      case 'dashboard':
        return t('adminPanel.dashboard', 'System Dashboard');
      case 'admin':
        return t('adminPanel.admin', 'System Administration');
      case 'notifications':
        return t('adminPanel.notifications', 'System Notifications');
      case 'approvals':
        return t('adminPanel.approvals', 'Pending Approvals');
      case 'orders':
        return t('adminPanel.pendingOrders', 'Pending Orders');
      default:
        return t('adminPanel.dashboard', 'System Dashboard');
    }
  };

  return (
    <div className="fixed bottom-0 left-0 right-0 z-50 bg-background border-t lg:hidden">
      <div className="flex justify-around items-center h-14 sm:h-16 px-2">
        {mobileTabs.map((tab) => (
          <button
            key={tab.id}
            onClick={() => setActiveTab(tab.id)}
            className={`flex flex-col items-center justify-center flex-1 h-full transition-colors px-1 ${
              activeTab === tab.id
                ? 'text-white bg-[#1B526A]'
                : 'text-muted-foreground hover:text-primary'
            }`}
          >
            <div className="flex items-center justify-center h-5 w-5 sm:h-6 sm:w-6">
              {React.cloneElement(getTabIcon(tab.id), { color: activeTab === tab.id ? 'white' : undefined })}
            </div>
            <span className="text-xs sm:text-sm mt-1 font-medium text-center">
              {getTabLabel(tab.id)}
            </span>
          </button>
        ))}
      </div>
    </div>
  );
} 