import { NextResponse } from 'next/server';
import { postgresClient } from '../../../../lib/postgresql-client';

export async function GET() {
  try {
    // First, let's check the structure of the devices table
    const tableInfo = await postgresClient.query(`
      SELECT column_name, data_type 
      FROM information_schema.columns 
      WHERE table_name = 'devices'
    `);
    console.log('Devices table structure:', tableInfo.rows);

    // Now query the devices with the correct column names
    const result = await postgresClient.query(`
      SELECT 
        ud.id,
        ud.user_id,
        COALESCE(d.device_name, 'Unknown') as device_name,
        COALESCE(d.device_type, 'Unknown') as device_type,
        ud.last_seen,
        ud.fcm_token
      FROM user_devices ud
      LEFT JOIN users u ON ud.user_id = u.user_id
      LEFT JOIN devices d ON CAST(u.device_id AS TEXT) = d.device_name
      ORDER BY ud.last_seen DESC NULLS LAST
    `);
    return NextResponse.json({ devices: result.rows });
  } catch (error) {
    console.error('Failed to fetch user devices:', error);
    return NextResponse.json({ 
      error: 'Failed to fetch user devices', 
      details: error instanceof Error ? error.message : 'Unknown error' 
    }, { status: 500 });
  }
} 